Trans Genocide
#essay #politics

Are trans people experiencing a genocide? Well, I hope we've learned from Gaza that when people start splitting hairs about whether events *technically* constitute genocide, something has gone terribly wrong. It does not at all reassure me that when I share my perfectly rational concerns,[^1] what seemingly bothers people most is my choice of words.

Still, skepticism is an understandable response to an accusation of genocide.[^2] After all, one motivation for using strong language like "genocide" is to draw attention to the severity of the issue, and that capacity might be compromised if the word is overused. As reasonable as it seems on its face, this line of criticism is ultimately tendentious. What is really at stake is not the capacity for words to stir emotion, but our capacity to speak meaningfully and truthfully. This category error contributed to years of handwringing, scolding, and generally irritating bullshit from the Serious Person Squad over whether we were allowed to call Donald Trump a fascist. It is not particularly important whether calling someone a "Nazi" arouses your feelings, but it is important whether that someone actually is a Nazi. After all, nobody will be stirred into action against said Nazi if they can't even identify him as one.

But that doesn't get us all the way to a G-card — the identification still needs to be correct, and Serious People contend it isn't. So, down to brass tacks: what *is* genocide, anyway? At this point, we could invoke a formal definition. There's actually one inscribed in law at the UN.[^3] We could also run down a list of features of genocide as identified by experts and tick off the ones that apply.[^4] (We could even use a dictionary, that old bellwether of bad internet arguments.) And there's obviously a place in the world for this sort of legalistic approach, but I don't think we need any of that here. The meaning of a word and its definition are two different things. A definition attempts to capture meaning that's already there, and I think we know what genocide is: it's when someone tries to wipe out an entire group of people. We're watching one, on our phones. Genocide is when humans treat each other the same way they treat an infestation of cockroaches.

So, is that happening to trans people? After all, they aren't dropping bombs on us. There's no paramilitary systematically murdering every trans person they can find. (Yet.) But there are many methods to wipe out an infestation, and there's no sense wasting all that effort when you can just put out poisoned roach traps. Maybe a better question is this: **how would a world where trans people were treated like an infestation *differ* from our own?**

I can't think of anything. Having the social status of a cockroach is just a straightforward description of life as a trans person. Accepting that status is the cost you know you have to pay to truly live.[^5] Many trans people live this way: hiding during the day, scurrying out at night, surviving on crumbs and human forbearance. Nobody[^6] denies that society treats trans people very badly, but we've always *been* cockroaches. Why are we getting so worked up about it *now*, when we've been treated like dirt for ages?

My answer is this: trans genocide is not a new phenomenon. Like Israel's recent slaughter of Palestinians and wholesale destruction of their country, we can clearly identify a sharp increase in the oppression, but it's part of a longer process. The Holocaust did not begin the moment the first gas chamber was turned on; the mass murder was preceeded by years of escalating oppression. Trans people have been surviving genocidal conditions for most of our history. When transphobia is swept aside as simple intolerance — an unavoidable social ill, not a calamity — it masks the physical realities of oppression: children abused and taught to hide and hate what they are; teenagers made homeless by their own parents; young women raped and disposed of in dumpsters; staggering numbers of people choosing death over this life.[^7] Violence and abuse against trans people are pervasive throughout our society to such an extent that our numbers were held firmly at ~0% of the population until the internet empowered us to organize without scurrying out and getting stomped on.

Keep in mind, this genocidal social context has been so thoroughly normalized that it also affects how trans people think. We're fish in water. We have low expectations for how we'll be treated, and work around it as best we can, like anyone does with obstacles in their daily life. So when conditions have worsened to the point where we flee our homes en masse,[^8] we can be confident the situation has become catastrophic, even if it gets us no closer to determining if a genocide has "officially" begun.

The reason things have deteriorated so badly is not complicated: there are people who want to wipe us out, and they have a great deal of money and power. Like Hitler and Ben-Gvir, they do not take great pains to hide this fact. Perhaps the most famous example was when Michael Knowles took the stage at CPAC and announced that "transgenderism must be eradicated from public life entirely",[^9] but the dedicated cockroach-stompers have always been clear about their intentions. Janice Raymond's landmark 1979 book The Transsexual Empire — basically, Mein Kampf for feminists who hate trans women — says that "the problem of transsexualism would best be served by morally mandating it out of existence". Women's Declaration International (then WHRC), a major psuedofeminist hate outfit backed by all the prominent transphobes,[^10] submitted a document to UK Parliament that calls for the "elimination of ... the practice of transgenderism".[^11] Eliminating trans people is a clear priority for the Trump regime, though they prefer the euphemism "gender ideology".[^12] Anyone who has ever lived among Republicans knows they generally feel the same way; random congressmen volunteer suggestions like:
> We have to get them off the streets, and we have to get them off the internet, and we can’t let them communicate with each other. I’m all about free speech, but this is a virus, this is a cancer.[^13]

But of course, we don't need any admission of motive. Their actions speak loudly enough. Why else would you ban medication that saves trans people's lives, if not to kill them? How much more obvious could their intentions possibly be? It's cold-blooded murder. It's no different than if they were to ban insulin: not *all* the diabetics would die, but it is not exactly hard to connect the causal dots. And that's only the tip of the iceberg when it comes to cruel, illegal, and exterminationist policy. They have two apparent policy priorities: 1) to make the world as hostile as possible to trans people, with an emphasis on children who can't fight back and on causing psychological devastation; 2) to erase trans people from society by banning and covering up our identities, language, and history. These two prongs meet to create what I think of as their worst crime: they aren't just erasing history and killing our loved ones, they're banning the future. They want to rob us of hope for a better tomorrow and ensure that the next generation of trans people has to start over from scratch.[^14]

Yes, trans people will always exist. But how many of them? What will their lives be like, and how long will they be? Will they even have the language to describe themselves?

You don't have to call it a genocide. It's just a word. You can call it pre-genocide, incitement, red flags, or whatever you want. But you cannot deny that our society has been swept by a powerful campaign to crush trans people like bugs.


[^1]: We've been told time and again that transmisogynist bigots' completely baseless fears must be pandered to, because they have "reasonable concerns". Reasonableness apparently requires no evidence, just technical plausibility. Trans people's fear of persecution is not only reasonable, it's backed with mountains of actual evidence, so we ought to be in solid epistemic territory. But who gets accused of overreacting?
[^2]: Skepticism is the correct default posture to *all* claims, as long as you don't mistake willful ignorance for it.
[^3]: This definition was arguably compromised by the same eliminationist bigotry toward trans and queer people which it fails to identify. After WWII, the Allies did not free the gay people imprisoned by the Nazis, continued arresting them, and reflexively erased them from Holocaust memory.
[^4]: I have taken this approach before, and it doesn't seem to have any effect. People just treat you like a lawyer arguing a technicality. Instead of elevating the affect of a word over its meaning, they conflate the two. You're giving them a definition, but they know the meaning is what really matters, and they judge whether that meaning applies based on whether they feel sufficiently outraged.
[^5]: It's an absolute bargain, but it's still not one anyone should have to make.
[^6]: ...who matters
[^7]: I do not consider this suicide; it is better understood as social murder.
[^8]: [[//www.erininthemorning.com/p/us-internal-refugee-crisis-130-260k]]
[^9]: If you've followed my cockroach analogy, you'll understand that the fig leaf of specifically *public* life is utterly without meaning. The ability to live in public, and the ability to live, full stop, are functionally identical. Knowles wants the cockroaches to run back into the walls.
[^10]: Except, curiously, JK Rowling, as far as I can tell. At least, she didn't sign their "Declaration on Women's Sex-Based Rights" (*eyeroll*). At the time she was a little more circumspect about her trans hatred and just did stuff like [[//www.thepinknews.com/2022/04/11/jk-rowling-lunch-get-the-l-out-anti-trans-rosie-duffield/|post photos sipping mimosas]] [[//web.archive.org/web/20220412023808/http://www.dailymail.co.uk/news/article-10707447/JK-Rowling-enjoys-meal-prominent-feminists-backing-Respect-Sex-campaign.html|with the genocidaires]].
[^11]: [[//committees.parliament.uk/writtenevidence/17510/html/]]
[^12]: [[//web.archive.org/web/20250121015439/http://www.whitehouse.gov/presidential-actions/2025/01/defending-women-from-gender-ideology-extremism-and-restoring-biological-truth-to-the-federal-government/]]
[^13]: [[//www.lgbtqnation.com/2025/09/gop-rep-says-we-need-to-remove-all-trans-people-from-streets-the-internet/]]
[^14]: One of the spurious legalistic rejoinders to trans genocide is that we don't qualify as "a people"; we are a naturally occurring variation of humans, so it is not possible to ever completely wipe us out. Setting aside that the feasibility of committing total genocide is not actually relevant, this analysis ignores the reality of our lives. We belong to trans communities; we have a shared culture, history, and political interests; we have built up the collective knowledge we need to flourish and the tenuous capacity to pass that knowledge on to the next generation, who we dearly hope will build on our progress and enjoy better lives. All of that capacity can be smashed to pieces, and in fact it already has been once recently, when the Nazis set us back 60 years.
