# _Possessor_ as Trans Horror #
#essay #horror #film #trans-reading

## Body horror and gender dysphoria
Films in the body horror genre are replete with images and themes that resonate with trans viewers.[^1] Gender dysphoria is a very common aspect of trans subjectivity, and perhaps the most salient type is body dysphoria. "Body dysphoria" is, of course, nearly a synonym of "body horror". Not all gender dysphoria rises to the intensity of *horror*, and not all body horror trades on horror at one's own body, but it is unsurprising that there is a high degree of thematic overlap.

Trans readings are most obvious in narratives of gradual degeneration that mirror the experience of unwanted puberty. In _The Fly_ (1986), Jeff Goldblum spends a great deal of time staring in a literal mirror, watching as he is slowly transformed into a monster with each passing day. Early in the process, he tries to shave insectile growths from his face; trans women often compare testosterone-induced body and facial hair to the legs of insects. While there are many possible readings, the puberty reading is an obvious one, even for cis viewers; puberty is a difficult experience for everyone.

Another recurring trope in body horror is dissociation/derealization/depersonalization. Characters often observe their own mutilation with an eerie detachment, powerless or unwilling to stop it. [[//genderanalysis.net/depersonalization/|This phenomenon is a common aspect of gender dysphoria]] that is powerfully depicted by Jane Schoenbrun and others working in the overlapping sister genre of psychological horror. Schoenbrun's masterpiece _I Saw The TV Glow_ (as well as their lesser work _We're All Going to the World's Fair_) foregrounds a frequently co-occurring theme: technology as a force that drives and mediates personal alienation, and that also promises the possibility of transcending the limits of the flesh. _Videodrome_ and _eXistenZ_ are other exemplars here. Neither techno-dissociation or -transcendance is uniquely trans, but again, the resonance is undeniable, particularly in the internet age.

More broadly, body horror highlights difficulties and discomfort with personal identity. It asks what (if anything) makes you you and whether it can be changed or taken away. While the popular transphobic notion of "gender confusion" is of little value — trans people are often less confused about their gender than cis people, who might not have ever thought about it — this is still a very trans theme: Is medical transition right for me? If I'm forced to detransition, will I still be myself? Is my difference something I can celebrate? Does my sexed embodiment matter? What even is gender?

Many works also lend themselves to a trans-hostile reading. They gawk at atypically sexed bodies and use transness as a visual shorthand for degeneration, emphasizing not the horror experienced by the tormented subject, but horror at the Other. Excessive, harmful, "unnatural" surgery is also a common trope. Films like _Tetsuo: The Iron Man_, _The Substance_, and _Crimes of the Future_ (2022) feature a protagonist addicted to harming their own body through surgical means. Sometimes the connection to trans identity is made explicit, such as with forced sex change narratives like _The Skin I Live In_ or gender variant characters like _Titane_. And of course, horror as a whole has a long history of transphobic, sensationalized portrayals of transness, like _Psycho_ and _Silence of the Lambs_.

One final thing to note is the prevalence of graphic sex, especially "deviant" sex.[^2] This is often the hardest aspect to interpret because it can serve so many different ends. It can even serve opposing ones simultaneously. Is it intended to shock, titillate? Both? Is it incidental and only "deviant" insofar as the world of the story is unlike our own? Is the film providing a venue for sexual practices that are otherwise suppressed, or contributing to their suppression? Is this really sex, or is it actually rape? The one constant is that body horror can be relied on to showcase sexuality that is rarely depicted elsewhere. This is often relevant to trans people, who are disproportionately queer and probably disproportionately kinky, on top of frequently having a more complex relationship with their sexuality than the cishet average due to dysphoria, trauma, and cissexist expectations.


## _Possessor_ (2020)
!! This section contains spoilers. You should watch the film before reading it. Also, nudity.

Brandon Cronenberg's films are brilliant, yet they do not receive anywhere near the level of acclaim they deserve. His work is perhaps overshadowed by that of his father, to which it owes an obvious debt. It feels as though he spent his whole life marinating in Cronenberg the elder's work, letting it suffuse every pore, then burst onto the film scene in a blaze of originality. So far, his films are consistently excellent, where his father's are of more mixed quality, hitting both incredible highs and forgettable lows. Brandon takes David's skin-crawling surrealism and shapes it into razor-sharp, absolutely unsparing hard science fiction. You could say I'm a fan. If you are unfamiliar with his work and have ten minutes to spare, check out his short film _[[//archive.org/details/please-speak-continuously-and-describe-your-experiences-as-they-come-to-you-2019_202403|Please Speak Continuously and Describe Your Experiences as They Come to You]]_.

For my money, _Possessor_ is the most criminally underrated of his films. His debut feature _Antiviral_ had some success among arthouse horror fans for its bizarre premise, and _Infinity Pool_ drew more mainstream attention. But _Possessor_, which sits between the two chronologically, seems to have had a muted reception, despite being his best film. Set in the near future, it depicts a professional assassin who possesses her victims using high technology then causes them to commit murder-suicide.

Going back to the common elements of body horror that I identified above as lending themselves to trans readings, it ticks off each box. The assassin, Tasya Vos, has lost herself in her job. Her mental state is degrading. When we first meet her, she chooses to stab her victim to death instead of using the gun she was provided. When it comes time to shoot herself, she is unable to do it. For a normal person, shooting yourself is a sign of poor mental health; for her, *not* shooting herself means something has gone wrong. Physically and psychologically, she resembles a ghost. The technology that pays her bills has exacted a terrible toll. She is estranged from her husband and child and approaches meeting with them the same way she prepares for a job, practicing her lines to herself. Her "real" life is just another role she plays. After each job she undergoes psychological evaluation to verify that she is still, technically, herself. So we have degeneration, depersonalization, techno-alienation and -transcendance, and yes, a heaping scoop of uncensored sex.

So, hecklers, you must forgive me for applying a trans lens to this film, because body horror's trans vibes are just the start. While Brandon Cronenberg is not, to my knowledge, transgender, and while the trans themes I identify are not exactly explicit, there's a lot more to this than "trans woman watches film, decides it's about gender". There are somehow still people who deny that the magnificent _Being John Malkovich_ is the transest movie ever made by an ostensible cis man, and it has an explicitly trans character. Cis critics even denied that _I Saw The TV Glow_, a movie about gender dysphoria made by a trans person, had anything to do with gender. So, if you find my analysis utterly ridiculous, may I gently suggest you adjust your worldview to one where cisness is not the default.

With that out of the way, here's what I think: gender dysphoria is central to _Possessor_ and you can't make any sense of it otherwise. I honestly don't think that can be reasonably contested. 

More open to debate is my further reading: that Tasya Vos is a genderqueer or transmasculine person who has been corrupted by the patriarchy and by an unhealthy coping strategy. At the least, Vos is a figure tormented by gender dysphoria into becoming a monster. Whether you take this as hostile or sympathetic to trans people is not very important to me, but I would lean sympathetic. That might seem strange given the monstrosity Vos becomes, but the film encourages us to see things from Vos's perspective; and it's in keeping with horror's tendency to exploit our fear not of monsters, but of becoming a monster.

Note: I will from here on refer to Vos with neutral pronouns, not as a judgment call about the character's identity, but to encourage awareness of the ineherent ambiguity and discourage firm conclusions.

### The calibrator
The first shot of the film is of Vos inserting a needle-tipped probe into the skull of the first victim, ie, Vos's own skull. We later learn that this is a device for calibrating the connection between the host body and the assassin possessing it. Vos looks into the mirror while slowly turning up the dial on the device. The victim's face moves through a variety of emotions, ultimately sobbing in despair, then moves back to a forced calm. (This performance by Gabrielle Graham is fantastic, by the way. It's unsettling to see such realistic emotional lability with no apparent external source.)

![[/img/screenshots/possessor/calibrator.jpg]]

I think this device is one of the most intriguing things about the movie's universe, despite the fact that it undercuts the "perfect crime" nature of Vos's job — a minor plot hole we can easily overlook. The calibrator seemingly must be used in front of a mirror. It appears to stimulate a range of strong emotions in order to anchor the possessor in the host body, but the fact that it requires a mirror indicates that this anchoring process is about self-identification. Mirrors encourage us to consider the connection between the mind and body, the internal and external selves. By experiencing these emotions while watching them play across the host's face, Vos mentally connects the host's body with their own: I feel this; they feel this; therefore they = me.

The device itself, though: it's a needle you insert that makes you feel more connected to your body. Sound familiar? Needles are a common delivery method for hormones, and strong emotions are often triggered immediately after an injection. It's tempting to read this as the sci-fi equivalent of HRT, but of course, it's being used to help Vos steal someone else's body, not feel more comfortable in their own. Instead of altering the body, it alters the mind. Thus, it might be closer to the *opposite* of HRT: conversion therapy in a box.

### Compatibility
Later, when Vos is assigned to possess Colin Tate, we're told (foreshadowing!) that his body is not very compatible with Vos, and so the mission will only last three to five days and the calibrator must be used at least daily. (Vos seems reticent to do this, probably because it's an unpleasant experience.) How we interpret this supposed incompatibility has significant implications for our understanding of Vos's gender identity. At first blush, one might assume that they are incompatible due to the fact that Colin is a man. And that might be true, but I increasingly suspect it's a red herring. There are all sorts of neurological reasons they might be incompatible, and as we saw in the beginning, the calibrator is still necessary when possessing a body with the same sex characteristics. We just don't have enough context to judge.

I say "supposed incompatibility" because the film gives us reason to suspect the "incompatibility" is actually an *excess* of compatibility. Vos's employers do not want them to become too attached to their life in the host. As things spiral out of control in the denouement, it's unclear where Vos ends and Colin begins. Vos even tells him, or themselves, that the murders were acts of his own agency: *You're the one in control.* Maybe the whole thing is just a power struggle, and Vos said this to try to manipulate him into killing himself, but we are shown tons of visuals of the two of them blurring together.

![[/img/screenshots/possessor/mask.jpg]]

Colin and Vos have a lot in common. They are both abused and exploited by incredibly invasive employers. They both work soul-killing jobs: Colin spies on ~~Amazon~~ Zoothroo users and harvests data about the most boring things in the scene; Vos gives up their identity and murders people, regularly experiencing suffering that includes committing suicide. They are both directly overseen for the entirety of their time on the clock. Colin's job even incorporates VR for no apparent reason, meaning his consciousness is transferred to a new perspective, akin to her possessions. (Hilariously, he even has a virtual desk and monitor inside the VR environment.) Colin's job is voyeuristic, while Vos's takes voyeur to a whole new level. Both of them have an inappropriately close connection with their employer: Colin's is his horrible father-in-law, Vos's plays therapist and demands to know Vos's thoughts in addition to ordering and overseeing contract kills. When Vos is told to start a fight with Colin's father-in-law, the rage on display could have come from either one of them: *You think you can step on me? I'm a giant!* The cover story that Colin had a breakdown under all the stress might not have been far off the mark.

Perhaps militating against this reading is the fact that Vos has a breakdown at Colin's job when assigned to spy on a couple having sex. A naked woman lies spread eagle on the bed, then a naked man walks into frame and starts eating her out. Why is this the trigger? Is it because Vos doesn't feel at home in a man's body? Because it reminds them of the body they will return to? Because Colin is turned on by it and reasserts control? Is it an incompatibility in sexual orientation? I'm not sure what to make of it, and it runs counter to some other observations, but it's clearly significant and tells us that sex/gender is central to the story.

### Depersonalization, sex, and masculinity
The couple being spied on by ~~Amazon~~ Zoothroo is not the first significant sex scene. After Vos's first assignment is complete, they request time off to try to reconnect with their family. (Vos's boss is not happy about this, reminding Vos that they separated and that Vos decided it was better that way.) Vos approaches this like another assignment: they practice greeting their family with no apparent emotion, then seem to fake the emotions when the time comes. Their real life is just another role to play, motions to go through. Very pre-transition trans. Later, they initiate sex with their husband by laying their head on his arm like a puppy. Cut to fucking: Vos is just lying there in the missionary position, clearly feeling nothing, absolutely dead inside. It's only when they remember plunging a knife into their victim's body that they feel anything. At first, it seems like Vos is haunted by it... but then, they get aroused and bite their husband.

![[/img/screenshots/possessor/dead-inside.jpg]]

What to make of this? Clearly Vos is no longer turned on by PIV with this man; what they really crave is violence. And notably, the form that violence takes is stabbing, the type most heavily freighted with psychosexual baggage: sticking something into the victim. This is a frequent trope in horror: women who are dispatched by repeated stabbing with a knife, echoing the violent insertion of a phallus. Recall too that Vos went out of their way to select a knife as the murder weapon.

Vos isn't forced to do this job. They could quit at any time, but they don't want to. It provides an outlet for something very dark that lurks inside them, an attraction to violence that is typically masculine. Vos's job is alienating them from their own humanity, but I think it's awakening something in them besides a love of violence. The simplest explanation is that they are sublimating their desire to sexually penetrate into a desire to violently penetrate.

We get further evidence of this when Vos possesses Colin. One of the first things they do is examine themself in the mirror. They look at their penis, then pick up their fiancee's panties and look at the vaginal discharge. There's no evidence of arousal at this point; they act as detached as ever. But why examine the panties? Maybe they were just contemplating their new sex. They didn't smell them. Still, Vos seems to be attracted to Colin's fiancee immediately. They stare at her while she's getting dressed; they walk up behind her, put their arms around her, tell her she smells good, and kiss her. The fiancee, Ava, immediately notices something is off, but first identifies it as Colin being in a good mood. Maybe the staring was part of Vos's voyeuristic tendency to study people, and maybe the kissing — which mimics what Vos observed while prepping for the job  — was just a ploy to win Ava's trust. Maybe.

What's really interesting is what happens when Vos and Ava fuck. Ava is on top in a distinctly dominant role: she puts her fingers in Vos/Colin's mouth, then wraps one hand around their neck and puts the other over their mouth. Vos grabs her hands and forces them behind her back, then sits up and flips them around so Ava is on her back. It's only at this point that Vos/Colin really seems to get into it. This is also when some "synchronization" issues begin to crop up: we see flickers of Vos's actual face; Vos/Colin looks uncomfortable; we see Colin screaming internally; Colin/Vos sits up. Then, Colin's body changes into Vos's, slim and breasted, except with a large penis. They continue thrusting it a little. With some reticence, they continue fucking. Closeups of an open eye are overlaid. Cut to Vos/Colin sitting alone with their head down in a pose suggestion exhaustion or dejection; they check in with their boss and say they are in perfect sync with the host.

![[/img/screenshots/possessor/dickgirl.jpg]]

This is the closest we get to an explicit trans moment in the film, but it is very explicit. Vos is embodied in their mind's eye as a woman with a large penis, rather like a fetishistic depiction of a trans woman. I imagine this is a polarizing scene for transfem viewers. It seems to use our bodies as a symbol of confusion or ambiguity. However, that symbol literalizes what Vos/Colin is experiencing; I suspect whether it's offensive comes down to whether you feel it was done for shock value or not, which I don't really think it was.

Just like the voyeuristic VR scene, sex has clearly triggered some sort of disconnect. And like the VR scene, it's not entirely clear why. One obvious explanation is that Vos is experiencing severe gender dysphoria leading to dissociation, but I don't think that quite fits. Vos seems numb and disconnected, yes, but that's how they always are; they literally *are* diconnected; it isn't their body. It's Colin whose face we see screaming in horror, presumably because he's powerless to stop this intruder from fucking his fiancee. Vos continues thrusting their cock, slightly, while they look down at themselves in detached wonder. And most significantly, the scene mirrors the earlier "dead inside" scene between Vos and their husband. Vos/Colin firmly rejects the submissive position that they occupied in the earlier sex scene and reverses it. This does not read as method acting to me: if they liked that role, they could have just kept it going; how they had sex had no relevance to the mission. Presumably Ava and Colin have had sex before and she knows what he likes; it's Vos who wants to be dominant.[^3]

![[/img/screenshots/possessor/dom.jpg]]

Sex in _Possessor_ seems to function like the opposite of the calibrator. The powerful emotions and bodily sensations it generates provide an opportunity for the host's identity to break through and assert itself. Whether this is because it creates gender dysphoria in the possessor or because it connects strongly to the host's psyche, it's clear that _Possessor_ sees sexuality as fundamental to self-conception, even moreso than strong emotion alone.

### Suicide
This may seem crass, but it feels significant to me that Vos's job centrally involves suicide. This is a topic that trans people are unfortunately quite familiar with. Our high suicide rates are now sufficiently well known that they are used to harass us and encourage us to inflict death on ourselves. As self-harm goes, the ability to kill yourself over and over again has got to take the cake.

Why have they begun having trouble going through with it? The job is clearly fucking them up, alienating them from their own humanity, causing them to experience mental lapses that interfere with their performance, but we never learn exactly why it's started to be a problem now. Is it just how long they've been doing the job? Never in the film do we see them successfully complete suicide. I think it fits with my point about [[#compatibility|compatibility]]: Vos is increasingly unable or unwilling to separate from the host body. Their ghostly, detached existence means there is less and less of them. They crave the taste of real existence that they get from their hosts.

This entire approach to life makes sense as a maladaptive coping mechanism for untreated gender dysphoria. As miserable as Vos's job is, it's an escape from real life. They get to spend time in a body that is not their own, living a life that is not their own. It's the grisly equivalent of spending your life in a drunken stupor watching television. Metaphorically, Vos has already committed suicide. The violence that they inflict on others is nothing compared to what they inflict on themselves.

### Family, gender roles, and stereotypes
There are some other, shallower reasons to read Vos as masculine. First of all, they're a professional murderer. That's statistically very unlikely for a woman. The personal items used to test their reintegration are stereotypically masculine: a butterfly they murdered, their grandfather's pipe. They also do not wear any makeup or other femme accoutrements.

Then there's their relationship with their family. Leaving your spouse to take care of your child alone while you go away to work is a common pattern for men, but much less common for women. Women typically fill the caring role at home while men fuck off. Not to mention that Vos seemingly only popped in to get their rocks off, then ditched, and the sex being bad seems like it sealed the deal on giving up on the family.

Vos's boss is the voice of the patriarchy. She encourages Vos to sever ties with their family: they're holding Vos back; interfering with their work; they're a danger to their family anyway. They're Vos's last thread of connection to humanity, and that's inconvenient. The company needs a killing machine, not a loving parent.

And of course, there's the finale. We learn that Vos's boss has possessed their child to ensure the mission is finished, and likely to ensure that Vos no longer has a family to steal their attention. In the end, it's Vos who annihilates their own child, screaming with the same hatred displayed during the earlier fight at the party. I speculated that that rage might have been genuinely Colin's; in this case, it is unambiguous that it genuinely belongs to Vos. This type of rage is about as male as it gets. It's unstable men who are prone to annihilate their family and themselves.

![[/img/screenshots/possessor/annihilation.jpg]]

In the final analysis, Vos's boss was right. She may have maneuvered them into the revelation, but the revelation was sincere. Vos's true feelings are that they despise their family and everything it represents. Empathy, domesticity, womanhood: Tasya Vos is not meant for these things. Their truth is unrestrained power and pounding blood. Their toxic masculinity is in service of a power structure that doesn't actually care about them — but since when is that new? Masculinity exists to turn men into weapons that protect male power.

Testosterone could have saved him.

![[/img/screenshots/possessor/tragic.jpg]]
[^1]: In this, and all my writing, I don't intend to speak for others or imply what I say is true of all trans people. Far from it; we are as diverse as any people group. I'm speaking from my own perspective, and generalize only because I think there are a non-negligible number of other trans people who have a similar perspective. Without the ability to assume some degree of shared experience, we wouldn't have the term "transgender" in the first place.
[^2]: I would consider erotic horror another sister genre to body horror. Besides heavy overlap in both Cronenbergs' films, see Julia Ducournau (_Raw_, _Titane_), Clive Barker's _Hellraiser_ series, _Possession_ (1981), _From Beyond_ (1986), _Under the Skin_ (2013), _The Substance_ (2024), and the entire "monsterfucker" genre. No really, see them, they're all good! Except for maybe the monsterfucker stuff. Do **not** watch _La Bête_ (1975) unless you are really into simulated bigfoot rape and unsimulated horse sex. I should have turned it off when it opened with what felt like an hour of close-ups of horse cock. I watched it so you don't have to. It's amazing what you can find at your local library.
[^3]: I realize I'm playing a little fast and loose with my sex terminology here. They're not exactly doing anything kinky. The change in position seems like a pretty vanilla exchange of power; normal give-and-take, not a clear dominant and submissive. But they shot the scene this way for a reason. They gave us close-ups of Ava's hand around Colin's throat and Colin's hands holding hers behind her back for a reason. I think that reason was to emphasize the shifting power in the scenario.
